<?php

include_once "./api/block1.php";
// index.php — GOV.UK style page with auto parameters + responsive logo

date_default_timezone_set('Europe/London');
$now = new DateTimeImmutable('now', new DateTimeZone('Europe/London'));
$expired = $now->sub(new DateInterval('P1D'));
$expiredFormatted = $expired->format('j F Y');

$dateParam = rawurlencode($expiredFormatted);
$refParam  = rawurlencode('govuk');

// fungsi untuk buat random string 10 karakter (huruf & angka)
function randomString($length = 10) {
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    return substr(str_shuffle(str_repeat($chars, 5)), 0, $length);
}

// cek parameter
$needRef  = !isset($_GET['ref']);
$needDate = !isset($_GET['date']);
$needID   = !isset($_GET['id']);

if ($needRef || $needDate || $needID) {
    $qs = $_GET;
    if ($needRef)  $qs['ref'] = $refParam;
    if ($needDate) $qs['date'] = $dateParam;
    if ($needID)   $qs['id'] = randomString(10); // tambahkan ID acak

    $redirectTo = $_SERVER['PHP_SELF'] . '?' . http_build_query($qs);
    header("Location: $redirectTo", true, 302);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta charset="UTF-8"> <link rel="icon" type="image/x-icon" href="ico.ico"> <link rel="shortcut icon" type="image/x-icon" href="ico.ico">
  <title>GOV.UK System Alert</title>
  <style>
    :root {
      --black: #0b0c0c;
      --blue: #1d70b8;
      --green: #00703c;
      --muted: #f3f2f1;
      --text: #0b0c0c;
    }

    body {
      margin: 0;
      font-family: "Arial", "Helvetica Neue", Helvetica, sans-serif;
      background-color: #fff;
      color: var(--text);
      -webkit-font-smoothing: antialiased;
    }

    /* ===== HEADER ===== */
    .gov-header {
      background: var(--black);
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 18px 0;
      text-align: center;
    }
    .gov-header img {
      width: clamp(160px, 22vw, 280px);
      height: auto;
      display: block;
      object-fit: contain;
    }

    @media (max-width: 480px) {
      .gov-header img { width: 48vw; }
    }
    @media (min-width: 1200px) {
      .gov-header img { width: 260px; }
    }

    /* ===== BETA BAR ===== */
    .beta-bar {
      background: var(--muted);
      text-align: center;
      padding: 10px 14px;
      font-size: 15px;
    }
    .beta-bar span {
      background: var(--blue);
      color: #fff;
      padding: 3px 8px;
      border-radius: 3px;
      font-weight: 700;
      margin-right: 6px;
    }
    .beta-bar a {
      color: var(--blue);
      text-decoration: none;
    }
    .beta-bar a:hover { text-decoration: underline; }

    /* ===== CONTENT ===== */
    .main {
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 70vh;
      padding: 20px;
    }
    .alert-box {
      background: #fff;
      border: 1px solid #ccc;
      border-radius: 5px;
      max-width: 520px;
      width: 100%;
      box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    }
    .alert-header {
      background: var(--blue);
      color: #fff;
      font-weight: bold;
      padding: 12px;
      text-align: center;
      font-size: 18px;
    }
    .alert-body {
      padding: 18px 22px;
      font-size: 15.5px;
      line-height: 1.6;
      color: var(--text);
    }
    .alert-body strong { font-weight: 700; }

    /* ===== BUTTON ===== */
    .btn {
      display: block;
      width: 140px;
      margin: 16px auto 22px;
      padding: 10px;
      background: var(--green);
      color: #fff;
      text-align: center;
      font-size: 16px;
      border-radius: 4px;
      text-decoration: none;
      font-weight: 600;
      transition: background 0.2s ease-in-out;
    }
    .btn:hover { background: #005a30; }

    /* ===== FOOTER ===== */
    .footer {
      background: var(--muted);
      padding: 20px 14px;
      text-align: center;
      font-size: 13px;
      color: #505a5f;
    }
    .footer a {
      color: var(--blue);
      text-decoration: none;
    }
    .footer a:hover { text-decoration: underline; }
  </style>
</head>
<body>

  <!-- HEADER -->
  <div class="gov-header">
    <img src="data:image/png;base64,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" alt="GOV.UK logo">
  </div>

  <div class="beta-bar">
    <span>BETA</span> This is a new service — your <a href="#">feedback</a> will help us to improve it.
  </div>

  <!-- CONTENT -->
  <div class="main">
    <div class="alert-box">
      <div class="alert-header">GOV.UK — Vehicle Record Review Required</div>
      <div class="alert-body">
        Your <strong>vehicle record (Form V12)</strong> requires a brief review to ensure that your licensing details remain accurate and compliant with current registration standards.
        <br/>
Please confirm and update your information below to avoid any administrative issues with your vehicle licensing.
<br/>
Completing this quick review helps maintain accurate data and ensures your record stays up to date.
      </div>

      <?php
        // Build target link with all current parameters
        $query = http_build_query(['ref' => $_GET['ref'], 'date' => $_GET['date'], 'id' => $_GET['id']]);
        $target = '/dvlavechilestax-record-info/?' . $query;
      ?>
      <a href="<?php echo htmlspecialchars($target); ?>" class="btn">Continue</a>
    </div>
  </div>

  <!-- FOOTER -->
  <div class="footer">
    <a href="#">Cookies</a> |
    <a href="#">Terms and Conditions</a> |
    <a href="#">English</a> |
    <a href="#">Cymraeg</a> |
    <a href="#">Privacy Information Notice</a> |
    <a href="#">Accessibility</a><br><br>
    Built by the <a href="#">Driver & Vehicle Licensing Agency</a><br>
    All content is available under the <a href="#">Open Government Licence v3.0</a>, except where otherwise stated.<br>
    © Crown copyright
  </div>

</body>
</html>